package gov.va.vamf.scheduling.varutility.clientapi;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.NullChecker;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import java.io.InputStream;
import java.net.URI;

public class PatientResourceClient {
	private static org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PatientResourceClient.class);
	private JerseyClientHandle jerseyClientHandle = null;

	public PatientResourceClient(JerseyClientHandle jerseyClientHandle) {
		log.debug("initializing patient resource client");
		this.jerseyClientHandle = jerseyClientHandle;
	}

	public Patients patientSearch(Patient prototype) {
		Patients patients = null;
		if (prototype != null) {
			WebTarget targetHandle = jerseyClientHandle.target().path("patients");
			targetHandle = addPatientSearchQueryParams(targetHandle, prototype);
			log.info("get uri " + targetHandle.getUri().toString());
			patients = targetHandle.request().get(Patients.class);
		} else {
			patients = new Patients();
		}

		return patients;
	}

	public Patients patientSearch(String searchString) {
		Patients patients = null;
		if (NullChecker.isNotNullish(searchString)) {
			WebTarget targetHandle = jerseyClientHandle.target().path("patients");
			targetHandle = addPatientSearchQueryParam(targetHandle, "searchstring", searchString);
			log.info("get uri " + targetHandle.getUri().toString());
			patients = targetHandle.request().get(Patients.class);
		} else {
			patients = new Patients();
		}

		return patients;
	}

	public Patient getPatient(URI uri) {
		WebTarget targetHandle = jerseyClientHandle.target(uri);
		log.info("get uri " + targetHandle.getUri().toString());
		return targetHandle.request().get(Patient.class);
	}

	public Patient getPatient(Patient patient) {
		return getPatient(patient.getSelfUri());
	}

	public PatientDemographics getDemographics(URI uri) {
		WebTarget targetHandle = jerseyClientHandle.target(uri);
		log.info("get uri " + targetHandle.getUri().toString());
		return targetHandle.request().get(PatientDemographics.class);
	}

	public PatientDemographics getDemographics(Patient patient) {
		return getDemographics(patient.getDemographicsUri());
	}

	private WebTarget addPatientSearchQueryParams(WebTarget target, Patient prototype) {
		target = addPatientSearchQueryParam(target, "lastname", prototype.getLastName());
		target = addPatientSearchQueryParam(target, "firstname", prototype.getFirstName());
		target = addPatientSearchQueryParam(target, "patientid", prototype.getId());
		target = addPatientSearchQueryParam(target, "ssn", prototype.getSsn());
		return target;
	}

	private WebTarget addPatientSearchQueryParam(WebTarget target, String queryParamKey, String queryParamValue) {
		if (NullChecker.isNotNullish(queryParamValue)) {
			target = target.queryParam(queryParamKey, queryParamValue);
		}
		return target;
	}

	public InputStream getPatientImage(Patient patient) {
		return getPatientImage(patient.getPatientImageUri());
	}

	public InputStream getPatientImage(URI uri) {
		WebTarget targetHandle = jerseyClientHandle.target(uri);
		log.info("get uri " + targetHandle.getUri().toString());
		Response response = targetHandle.request().get();
		InputStream image = null;
		if (response.getStatus() == 200) {
			image = (InputStream)response.getEntity();
		}
		return image;
	}

	public Problems getPatientActiveProblems(Patient patient) {
		return getPatientActiveProblems(patient.getProblemsUri());
	}

	public Problems getPatientActiveProblems(URI uri) {
		WebTarget targetHandle = jerseyClientHandle.target(uri);
		log.info("get uri " + targetHandle.getUri().toString());
		Problems problems = targetHandle.request().get(Problems.class);
		return problems;
	}

	public Documents getPatientDocuments(Patient patient) {
		return getPatientDocuments(patient.getDocumentsUri());
	}

	public Documents getPatientDocuments(URI uri) {
		WebTarget targetHandle = jerseyClientHandle.target(uri);
		log.info("get uri " + targetHandle.getUri().toString());
		Documents documents = targetHandle.request().get(Documents.class);
		return documents;
	}

	public Allergies getPatientAllergies(Patient patient) {
		return getPatientAllergies(patient.getAllergiesUri());
	}

	public Allergies getPatientAllergies(URI uri) {
		WebTarget targetHandle = jerseyClientHandle.target(uri);
		log.info("get uri " + targetHandle.getUri().toString());
		Allergies allergies = targetHandle.request().get(Allergies.class);
		return allergies;
	}

	public LabTestGroups getPatientLabTestGroups(URI uri) {
		WebTarget targetHandle = jerseyClientHandle.target(uri);
		log.info("get uri " + targetHandle.getUri().toString());
		LabTestGroups labTestGroups = targetHandle.request().get(LabTestGroups.class);
		return labTestGroups;
	}


}
